VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
  Persistable = 0  'NotPersistable
  DataBindingBehavior = 0  'vbNone
  DataSourceBehavior  = 0  'vbNone
  MTSTransactionMode  = 0  'NotAnMTSObject
END
Attribute VB_Name = "Cemployee"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = True
Option Explicit

Private m_Name As String
Private m_SSN As String
Private m_PayRate As Double
Private m_Hours As Double
Private m_StartDate As Date

'*******************************************************************
' Employee Properties
'*******************************************************************
Public Property Let Name(NewName As String)
    m_Name = NewName
End Property
Public Property Get Name() As String
    Name = m_Name
End Property

Public Property Let SSN(sData As String)
    m_SSN = sData
End Property
Public Property Get SSN() As String
    SSN = m_SSN
End Property

Public Property Let PayRate(sData As Double)
    m_PayRate = sData
End Property
Public Property Get PayRate() As Double
    PayRate = m_PayRate
End Property

Public Property Let Hours(sData As Double)
    m_Hours = sData
End Property
Public Property Get Hours() As Double
    Hours = m_Hours
End Property

Public Property Let StartDate(dtDate As Date)
    m_StartDate = dtDate
End Property

Public Property Get StartDate() As Date
    StartDate = m_StartDate
End Property

'*******************************************************************
' Employee methods
''*******************************************************************
Public Function AsString() As String
    Dim sEmp As String
    
    sEmp = "Name: " & vbTab & m_Name & vbCrLf
    sEmp = sEmp & "ID: " & vbTab & m_SSN & vbCrLf
    sEmp = sEmp & "PayRate: " & vbTab & m_PayRate & vbCrLf
    sEmp = sEmp & "Hours: " & vbTab & m_Hours & vbCrLf
    sEmp = sEmp & "Start Date: " & Format(m_StartDate, "long date") & vbCrLf
    AsString = sEmp
End Function

Public Function IsValid() As Boolean
    Dim bIsValid As Boolean
    bIsValid = True
    
    If m_Name = "" Then
        bIsValid = False
    ElseIf m_SSN = "" Then
        bIsValid = False
    ElseIf Not IsNumeric(Trim(m_PayRate)) Then
        bIsValid = False
    ElseIf Not IsNumeric(Trim(m_Hours)) Then
        bIsValid = False
    ElseIf Not IsDate(Trim(m_StartDate)) Then
        bIsValid = False
    End If
    
    IsValid = bIsValid
    
End Function

Public Function AsHTML() As String
    Dim sResult As String
    
    sResult = "<table border=0 width=500>"
    sResult = sResult & "<tr><td width=100>Name:</td><td width=400>" & m_Name & "</td></tr>"
    sResult = sResult & "<tr><td>ID:</td><td>" & m_SSN & "</td></tr>"
    sResult = sResult & "<tr><td>Pay Rate:</td><td>" & m_PayRate & "</td></tr>"
    sResult = sResult & "<tr><td>Hours:</td><td>" & m_Hours & "</td></tr>"
    sResult = sResult & "<tr><td>Start Date:</td><td>" & m_StartDate & "</td></tr>"
    sResult = sResult & "</table>"
  
    AsHTML = sResult
End Function

Public Function GetAll() As ADODB.Recordset
    Dim rs As New Recordset
    With rs
        .Source = "Select * FROM Employees"
        .ActiveConnection = deEmpData.cnnEmpData
        .LockType = adLockReadOnly
        .CursorType = adOpenStatic
    End With
    
    Set GetAll = rs
    
End Function

